<?php
function connectToDatabase() {
    include('/home/applysc/api.apply-scan.com/config/db_config.php');
    $conn = new mysqli($servername, $username, $password, $dbname);

    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    return $conn;
}

function insertCalibrationData($device, $calibrationTable, $macAddress) {
    $conn = connectToDatabase();
    $stmt = $conn->prepare("INSERT INTO RulerCalibration (device, calibrationTable, macAddress, count) VALUES (?, ?, ?, 0)");
    $stmt->bind_param("sss", $device, $calibrationTable, $macAddress);
    
    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo "New record created successfully";
            $stmt->close();
            $conn->close();
            return true; // Успешное добавление записи
        } else {
            echo "No record was added (possible duplicate data)";
            $stmt->close();
            $conn->close();
            return false; // Ни одна запись не была добавлена
        }
    } else {
        echo "Error: " . $stmt->error;
        $stmt->close();
        $conn->close();
        return false; // Ошибка при выполнении запроса
    }
}

function updateCalibrationData($macAddress, $device, $calibrationTable) {
    $conn = connectToDatabase();

    $stmt = $conn->prepare("UPDATE RulerCalibration SET device = ?, calibrationTable = ? WHERE macAddress = ?");
    $stmt->bind_param("sss", $device, $calibrationTable, $macAddress);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo "Record updated successfully";
            $stmt->close();
            $conn->close();
            return true; // Успешное обновление
        } else {
            echo "No record was updated (no changes made)";
            $stmt->close();
            $conn->close();
            return false; // Обновление не произошло
        }
    } else {
        echo "Error: " . $stmt->error;
        $stmt->close();
        $conn->close();
        return false; // Ошибка при выполнении запроса
    }
}

function getCalibrationTable($device) {
    $conn = connectToDatabase();

    $stmt = $conn->prepare("SELECT calibrationTable FROM RulerCalibration WHERE device = ?");
    $stmt->bind_param("s", $device);
    $stmt->execute();
    $stmt->bind_result($calibrationTable);
    $stmt->fetch();
    if (incrementRequestCount($device)) {}; 
    $stmt->close();
    $conn->close();

    if ($calibrationTable) {
        return $calibrationTable;
    } else {
        return null;
    }
}

function getCalibrationTableByMAC($macAddress) {
    $conn = connectToDatabase();

    $stmt = $conn->prepare("SELECT calibrationTable FROM RulerCalibration WHERE macAddress = ?");
    $stmt->bind_param("s", $macAddress);
    $stmt->execute();
    $stmt->bind_result($calibrationTable);
    $stmt->fetch();
   

    $stmt->close();
    $conn->close();

    if ($calibrationTable) {
        return $calibrationTable;
    } else {
        return null;
    }
}

function checkIfDeviceExists($device) {
    $conn = connectToDatabase();

    $stmt = $conn->prepare("SELECT COUNT(*) FROM RulerCalibration WHERE device = ?");
    $stmt->bind_param("s", $device);
    $stmt->execute();
    $stmt->bind_result($count);
    $stmt->fetch();

    $stmt->close();
    $conn->close();

    return $count > 0;
}

function incrementRequestCount($device) {
    $conn = connectToDatabase();

    $stmt = $conn->prepare("UPDATE RulerCalibration SET count = count + 1 WHERE device = ?");
    $stmt->bind_param("s", $device);
    $stmt->execute();

    $stmt->close();
    $conn->close();
}
?>
