<?php
// Подключение файлов с функциями
include('/home/applysc/api.apply-scan.com/config/database_functions.php');

// Получение действия из POST или GET запроса
$action = $_POST['action'] ?? $_GET['action'];

if ($action == 'insert') {
    if (isset($_POST['device']) && isset($_POST['calibrationTable']) && isset($_POST['macAddress'])) {
        
        error_log("Get Device: " . $_POST['device']);
        error_log("Get MAC: " . $_POST['macAddress']);

        $device = $_POST['device'];
        $macAddress = $_POST['macAddress'];
        $calibrationTable = urldecode($_POST['calibrationTable']); // Декодирование таблицы данных

        // Проверка, существует ли устройство в базе данных по MAC-адресу
        $existingTable = getCalibrationTableByMAC($macAddress);

        if ($existingTable) {
            // Устройство найдено по MAC-адресу, обновление таблицы
            if (updateCalibrationData($macAddress, $device, $calibrationTable)) {
                $msg = "Success: Record updated successfully.";
                echo $msg;
                error_log($msg);
            } else {
                $msg = "Error: Failed to update record.";
                echo $msg;
                error_log($msg);
            }
        } else {
            // Устройство не найдено, добавление новой записи
            if (insertCalibrationData($device, $calibrationTable, $macAddress)) {
                $msg = "Success: Record added successfully.";
                echo $msg;
                error_log($msg);
            } else {
                $msg = "Error: Failed to add record.";
                echo $msg;
                error_log($msg);
            }
        }
    } else {
        $msg = "Error: Device, MAC address, or calibrationTable data is missing.";
        echo $msg;
        error_log($msg);
    }
} elseif ($action == 'get') {
    if (isset($_GET['device'])) {
        $device = $_GET['device']; // Прямое использование без декодирования, т.к. уже не шифруем
        $calibrationTable = getCalibrationTable($device);

        if ($calibrationTable) {
            echo $calibrationTable; // Таблица данных передается как есть
            error_log("Calibration table sent for device: " . $device);
        } else {
            $msg = "Error: Calibration table not found for device $device.";
            echo $msg;
            error_log($msg);
        }
    } else {
        $msg = "Error: Device data is missing.";
        echo $msg;
        error_log($msg);
    }
} else {
    $msg = "Error: Unknown action.";
    echo $msg;
    error_log($msg);
}
?>